import pygame
import random
import os

pygame.init()

# macht quadrat
def draw_square(column, row, color):
    screen_x = column * SQUARE_SIZE
    screen_y = row * SQUARE_SIZE
    pygame.draw.rect(screen, color, (screen_x, screen_y, SQUARE_SIZE, SQUARE_SIZE))

# Laden und überscfhreiben vom highscore und so
def load_highscore():
    if os.path.exists("highscore.txt"):
        with open("highscore.txt", "r") as file:
            return int(file.read().strip())
    return 0

def save_highscore(score):
    with open("highscore.txt", "w") as file:
        file.write(str(score))

# Variablen für dings
GROESSE = 900
SQUARE_COUNT = 20
SQUARE_SIZE = GROESSE / SQUARE_COUNT
START_LENGTH = 5
DELAY = 100

screen = pygame.display.set_mode((GROESSE, GROESSE))
pygame.display.set_caption("Snake")

score = 0
highscore = load_highscore()

# scoreboard font
font = pygame.font.SysFont("Arial", 30, bold=True)

head_column = SQUARE_COUNT // 2
head_row = SQUARE_COUNT // 2
snake_length = START_LENGTH
body_parts = []
step_x = 0
step_y = 0
apple_row = random.randint(0, SQUARE_COUNT - 1)
apple_column = random.randint(0, SQUARE_COUNT - 1)

run = True
while run:
    pygame.time.delay(DELAY)

    # Event Handling
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            run = False

    keys = pygame.key.get_pressed()
    if keys[pygame.K_RIGHT] and step_x != -1:
        step_x = 1
        step_y = 0
    elif keys[pygame.K_LEFT] and step_x != 1:
        step_x = -1
        step_y = 0
    elif keys[pygame.K_UP] and step_y != 1:
        step_x = 0
        step_y = -1
    elif keys[pygame.K_DOWN] and step_y != -1:
        step_x = 0
        step_y = 1

    # Bewegung des Kopf
    head_column += step_x
    head_row += step_y

    # Snake wird größerr
    body_parts.append((head_column, head_row))
    if len(body_parts) > snake_length:
        body_parts.pop(0)

    # wenn Apfel isst wird score erhöht
    if head_column == apple_column and head_row == apple_row:
        snake_length += 1
        score += 10  # +10 Punkte pro Apfel
        apple_row = random.randint(0, SQUARE_COUNT - 1)
        apple_column = random.randint(0, SQUARE_COUNT - 1)

    # if ob sie an die wand kommt
    if (head_column, head_row) in body_parts[:-1] or head_column < 0 or head_column >= SQUARE_COUNT or head_row < 0 or head_row >= SQUARE_COUNT:
        # highscore save
        if score > highscore:
            highscore = score
            save_highscore(highscore)

        # setzt spiel zurück also die variablen
        score = 0
        head_column = SQUARE_COUNT // 2
        head_row = SQUARE_COUNT // 2
        snake_length = START_LENGTH
        body_parts = []
        step_x = 0
        step_y = 0

    # Bildschirm aktualisieren
    screen.fill((0, 0, 0))

# Zeichnen der Snake in Babyblau
    draw_square(head_column, head_row, (137, 207, 240))
    for part in body_parts:
        draw_square(part[0], part[1], (119, 190, 238))  # Etwas dunkler für den Körper


    # Zeichnen von den Äpfeln
    draw_square(apple_column, apple_row, (255, 0, 0))

    # Zeigt score an
    score_text = font.render(f"Aktueller Score: {score} | Highscore: {highscore}", True, (255, 255, 255))
    screen.blit(score_text, (10, 10))  # Position oben links

    # zeichnen des Grid
    for i in range(SQUARE_COUNT):
        line_pos = SQUARE_SIZE * i
        pygame.draw.line(screen, (32, 32, 32), (line_pos, 0), (line_pos, GROESSE), 1)
        pygame.draw.line(screen, (32, 32, 32), (0, line_pos), (GROESSE, line_pos), 1)

    pygame.display.update()

pygame.quit()